/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp.cmdhelpers;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.fsp.FSPCmdMgr;
import java.util.Calendar;
import java.util.Hashtable;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class FspCecTime {
    private int mYear;
    private int mMonth;
    private int mDay;
    private int mHour;
    private int mMinute;
    private int mSecond;
    private int mMicroSec;
    private static final String YEAR = "YEAR";
    private static final String MONTH = "MONTH";
    private static final String DAY = "DAY";
    private static final String HOUR = "HOUR";
    private static final String MINUTE = "MINUTE";
    private static final String SECOND = "SECOND";
    private static final String MICRO_SECOND = "MICRO_SECOND";
    private static final String GET_CEC_TIME_OF_DAY = "GET_CEC_TIME_OF_DAY";
    private static final String SET_CEC_TIME_OF_DAY = "SET_CEC_TIME_OF_DAY";

    FspCecTime() {
    }

    FspCecTime getCecTimeOfDayCmd(FSPCmdMgr fSPCmdMgr, String string) throws PIHscServerException, PIHscCmdMgrException {
        boolean bl = false;
        if (string != null && string.indexOf("Default") == -1) {
            bl = true;
        }
        Hashtable hashtable = fSPCmdMgr.doFSPCommand(GET_CEC_TIME_OF_DAY, null);
        int n = ((UnsignedInt16)hashtable.get(YEAR)).intValue();
        int n2 = ((UnsignedInt8)hashtable.get(MONTH)).intValue();
        int n3 = ((UnsignedInt8)hashtable.get(DAY)).intValue();
        int n4 = ((UnsignedInt8)hashtable.get(HOUR)).intValue();
        int n5 = ((UnsignedInt8)hashtable.get(MINUTE)).intValue();
        int n6 = ((UnsignedInt8)hashtable.get(SECOND)).intValue();
        this.mYear = this.convertBCD(n, 4);
        this.mMonth = this.convertBCD(n2, 2);
        this.mDay = this.convertBCD(n3, 2);
        this.mHour = this.convertBCD(n4, 2);
        this.mMinute = this.convertBCD(n5, 2);
        this.mSecond = this.convertBCD(n6, 2);
        int n7 = (int)((UnsignedInt32)hashtable.get(MICRO_SECOND)).longValue();
        this.mMicroSec = this.convertBCD(n7, 6);
        return this;
    }

    void setCecTimeOfDayCmd(FSPCmdMgr fSPCmdMgr, String string, Long l) throws PIHscServerException, PIHscCmdMgrException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        this.mYear = calendar.get(1);
        this.mMonth = calendar.get(2);
        this.mDay = calendar.get(5);
        this.mHour = calendar.get(11);
        this.mMinute = calendar.get(12);
        this.mSecond = calendar.get(13);
        this.mMicroSec = calendar.get(14) * 1000;
        String string2 = String.valueOf(this.convert2BCD(this.mYear));
        String string3 = String.valueOf(this.convert2BCD(this.mMonth + 1));
        String string4 = String.valueOf(this.convert2BCD(this.mDay));
        String string5 = String.valueOf(this.convert2BCD(this.mHour));
        String string6 = String.valueOf(this.convert2BCD(this.mMinute));
        String string7 = String.valueOf(this.convert2BCD(this.mSecond));
        String string8 = String.valueOf(this.convert2BCD(this.mMicroSec));
        String[] stringArray = new String[]{string2, string3, string4, string5, string6, string7, string8};
        this.jdebug(".setCecTimeOfDayCmd -> FspCmdMgr.doFspCommand " + string2 + "," + string3 + "," + string4 + "," + string5 + "," + string6 + "," + string7 + "," + string8);
        Hashtable hashtable = fSPCmdMgr.doFSPCommand(SET_CEC_TIME_OF_DAY, stringArray);
    }

    void jdebug(String string) {
        System.err.println("FspCecTime" + string);
    }

    public int getYear() {
        return this.mYear;
    }

    public int getMonth() {
        return this.mMonth;
    }

    public int getDay() {
        return this.mDay;
    }

    public int getHour() {
        return this.mHour;
    }

    public int getMinute() {
        return this.mMinute;
    }

    public int getSecond() {
        return this.mSecond;
    }

    public int getMicroSec() {
        return this.mMicroSec;
    }

    private int convert2BCD(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n > 0) {
            n3 = n % 10;
            n -= n3;
            n /= 10;
            n2 |= n3 << 4 * n4;
            ++n4;
        }
        return n2;
    }

    private int convertBCD(int n, int n2) {
        int n3 = 0;
        int n4 = n;
        int n5 = 1;
        for (int i = 0; i < n2; ++i) {
            n3 += (n4 & 0xF) * n5;
            n4 = (n4 & 0xFFFFFFF0) >> 4;
            n5 *= 10;
        }
        return n3;
    }

    public long getTimeInMillis() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(this.mYear, this.mMonth - 1, this.mDay, this.mHour, this.mMinute, this.mSecond);
        long l = calendar.getTimeInMillis();
        return l += (long)(this.mMicroSec / 1000);
    }

    public String toString() {
        String string = "year=" + this.mYear;
        String string2 = "month=" + this.mMonth;
        String string3 = "day=" + this.mDay;
        String string4 = "hour=" + this.mHour;
        String string5 = "minute=" + this.mMinute;
        String string6 = "second=" + this.mSecond;
        String string7 = "microSec=" + this.mMicroSec;
        return string + "; " + string2 + "; " + string3 + "; " + string4 + "; " + string5 + "; " + string6 + "; " + string7;
    }
}

